/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ChemicalContainerItemStrategy
implements ContainerItemStrategy<MekanismKey, Context> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Capability<ISlurryHandler> capability : List.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY)) {
            ChemicalStack chemical;
            Optional contained = stack.getCapability(capability).map(handler -> handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE));
            if (!contained.isPresent() || (chemical = (ChemicalStack)contained.get()).isEmpty()) continue;
            MekanismKey key = MekanismKey.of(chemical);
            if (key == null) {
                return null;
            }
            return new GenericStack((AEKey)key, chemical.getAmount());
        }
        return null;
    }

    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.m_142621_();
        if (Stream.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY).anyMatch(capability -> carried.getCapability(capability).isPresent())) {
            return new Context(player, menu, carried);
        }
        return null;
    }

    public long extract(Context context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = ChemicalBridge.withAmount(what.getStack(), amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return context.stack().getCapability(MekCapabilities.GAS_HANDLER_CAPABILITY).map(handler -> ((GasStack)handler.extractChemical((ChemicalStack)gas, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return context.stack().getCapability(MekCapabilities.INFUSION_HANDLER_CAPABILITY).map(handler -> ((InfusionStack)handler.extractChemical((ChemicalStack)infusion, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return context.stack().getCapability(MekCapabilities.PIGMENT_HANDLER_CAPABILITY).map(handler -> ((PigmentStack)handler.extractChemical((ChemicalStack)pigment, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return context.stack().getCapability(MekCapabilities.SLURRY_HANDLER_CAPABILITY).map(handler -> ((SlurryStack)handler.extractChemical((ChemicalStack)slurry, action)).getAmount()).orElse(0L);
        }
        throw new UnsupportedOperationException();
    }

    public long insert(Context context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = ChemicalBridge.withAmount(what.getStack(), amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return context.stack().getCapability(MekCapabilities.GAS_HANDLER_CAPABILITY).map(handler -> amount - ((GasStack)handler.insertChemical((ChemicalStack)gas, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return context.stack().getCapability(MekCapabilities.INFUSION_HANDLER_CAPABILITY).map(handler -> amount - ((InfusionStack)handler.insertChemical((ChemicalStack)infusion, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return context.stack().getCapability(MekCapabilities.PIGMENT_HANDLER_CAPABILITY).map(handler -> amount - ((PigmentStack)handler.insertChemical((ChemicalStack)pigment, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return context.stack().getCapability(MekCapabilities.SLURRY_HANDLER_CAPABILITY).map(handler -> amount - ((SlurryStack)handler.insertChemical((ChemicalStack)slurry, action)).getAmount()).orElse(0L);
        }
        throw new UnsupportedOperationException();
    }

    public void playFillSound(Player player, MekanismKey what) {
        player.m_6330_(SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void playEmptySound(Player player, MekanismKey what) {
        player.m_6330_(SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    public GenericStack getExtractableContent(Context context) {
        ItemStack held = context.menu.m_142621_();
        for (Capability<ISlurryHandler> capability : List.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY)) {
            ChemicalStack chemical;
            MekanismKey key;
            IChemicalHandler handler = held.getCapability(capability).resolve().orElse(null);
            if (handler == null || (key = MekanismKey.of(chemical = handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE))) == null) continue;
            return new GenericStack((AEKey)key, chemical.getAmount());
        }
        return null;
    }

    record Context(Player player, AbstractContainerMenu menu, ItemStack stack) {
    }
}

